/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef mi_h
#define mi_h

#include <stdlib.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_raw.h"
#include "mx_byteswap.h"
#include "mx_int.h"
#include "mx__shim.h"

#define MI_MY_SIZE 2
#define MI_POLL_USECS 0

#define mi_u32_t uint32_t
#define mi_u8_t uint8_t
#define mi_s8_t int8_t
#define mi_u16_t uint16_t

#define mi_htonl(x) htonl(x)
#define mi_htons(x) htons(x)

extern int mi_verbose_flag;
void mi_println_verbose_function (const char*fmt,...);
#define mi_c(p) if (mi_verbose_flag) mi_println_verbose_function p

typedef struct lx_node_t*mi_index_t;
typedef unsigned mi_weight_t;

struct lx_node_t;
struct lx_t;

typedef struct buffer_t
{
  void*context;
  int small;
  struct buffer_t*next;

  char p [1];

}buffer_t;

struct mi_alarm
{
  unsigned prev_time;
  unsigned duration;
  int set;
};


#define NUM_SMALLS (LX_NUM_SMALLS + LX_NUM_REPLIES)
#define NUM_RECEIVES 40

typedef struct mi_t
{
  mx_raw_endpoint_t endpt;
  char mx_address [6];

  buffer_t*bigs;
  buffer_t*smalls;
  buffer_t*receives [NUM_RECEIVES];
  struct mi_alarm alarm;
  int mapping;
}mi_t;

typedef struct mi_node_data_t
{
  int dc;

}mi_node_data_t;

typedef struct mi_go_t
{
  struct lx_t*lx;
  int unit;
  int level;
  int clos;
  int check_xbars;
  int map_once;
  int printeur;
}mi_go_t;

void mi_send (struct lx_t*lx, int port, void*route, unsigned route_length, void*p, unsigned length, void*context);
void mi_set_alarm (struct lx_t*lx, unsigned duration);
void mi_set_route (struct lx_t*lx, int index, unsigned char mac_address [6], int host_type, int host_index, int iport, int oiport, signed char*route, unsigned length);
void mi_set_route_begin (struct lx_t*lx);
void mi_set_route_end (struct lx_t*lx);
void mi_get_address (struct lx_t*lx, unsigned char mac_address [6]);
void mi_set_map_version (struct lx_t*lx, int iport, unsigned char mac_address [6], unsigned map_version, unsigned num_hosts, int done_everywhere, int valid, int kids_match);
int mi_wait (struct lx_t*lx, int*iport, void*message, unsigned*length, void*contexts [], int early);

#define mi_index2node(index)index
#define mi_node2index(n)n

void mi_println_map (struct lx_t*lx, const char*fmt,...);

extern void mi_fail ();
extern int mi_is_demon;
extern void mi_syslog (const char*fmt,...);
extern void mi_errlog (const char*fmt,...);
#define insist(e) if(!(e)) {fflush(stdout);fprintf (stderr,"assertion failed. %s:%d (%s)\n", __FILE__,__LINE__, #e); mi_syslog ("assertion failed. %s:%d (%s)\n", __FILE__,__LINE__, #e);mi_fail (); goto except;}
#define mi_panic(e) do { mi_errlog e; mi_syslog e;mi_fail (); goto except;} while(0)

#define MI_RAND_MAX RAND_MAX
extern int mi_rand ();
#define mi_memcpy memcpy

unsigned mi_time(struct lx_t*lx);
struct lx_map_t;
struct lx_t;
void mi_dump_map (struct lx_t*lx, int iport, struct lx_map_t*m);
#define mi_match(i,a,b)1
#define mi_punt(lx)
#define mi_printeur_lx 0
#define MI_MAX_HOSTS_PER_MAP_REPLY lx_piece_count (lx_map_host_t)
#undef LX_ACTIVE_TIMEOUT
#define LX_ACTIVE_TIMEOUT (12 * 1000) 

void mi_go (struct lx_t*lx, int unit);
void mi_check_file_routes(struct lx_map_t *real_map,
                          struct lx_node_t *real_me,
                          int port, int route_index);

#if !MX_OS_WINNT
#define MI_CAN_BE_A_DAEMON 1
#define MI_OS_WINNT 0
#else
#define MI_CAN_BE_A_DAEMON 0
#define MI_OS_WINNT 1
#endif

#endif /*mi_h*/
